#
#	Code that plots FDR and FPR curves for DESeq, edgeR, their polyfit versions, 
#		PoissonSeq and QuasiSeq.  Called by <FDR_and_FPR_Fig_5>
#
#	Conrad Burden 21/05/14
#
#
#	Generate Pickrel-like data and copy into a data frame
#
	pi0set <- 1 - pDE
#
	if(exists("countsTableWithDE"))rm(countsTableWithDE)
	source("Generate Simulated Data Variable Library.R")
#
	conds <- group <- factor(c(rep("A", nrep1), rep("B", nrep2)), levels=c("A", "B"))
	countsTableWithDE <- syntheticDataTable[c(5:(4 + nrep1),29:(28 + nrep2))]
#	countsTableWithDE <- syntheticDataTable[c(5:(4 + nrep1),9:(8 + nrep2))]
	rownames(countsTableWithDE) <- syntheticDataTable$ID
#
#	Remove tags with small numbers of counts (can comment out if preferred)
#
	genesKept <- rowSums(countsTableWithDE) > (nrep1 + nrep2)
	countsTableWithDE <- countsTableWithDE[genesKept,]
	notDE <- !syntheticDataTable$regDirection[genesKept]
	nGene <- nrow(countsTableWithDE)
#
#
#	QuasiSeq p-values, q-values & FDR
#
	counts <- as.matrix(countsTableWithDE)
	design.list <- vector("list",2)
	design.list[[1]] <- c(rep(1, nrep1), rep(2, nrep2))
	design.list[[2]] <- rep(1, ncol(counts))
	size <- apply(counts, 2, quantile, 0.75)
	fit <- QL.fit(counts, design.list,log.offset=log(size), Model="NegBin")
	results <- QL.results(fit, Plot=FALSE)
#
	pvalQL <- results$P.values$QL
	qvalQL <- results$Q.values$QL		
	pvalQLShrink <- results$P.values$QLShrink
	qvalQLShrink <- results$Q.values$QLShrink	
	pvalQLSpline <- results$P.values$QLSpline
	qvalQLSpline <- results$Q.values$QLSpline
#
	ord <- order(pvalQLSpline)
	FDR_QLSpline <- cumsum(notDE[ord])/(1:nGene) 
	FPR_QLSpline <- cumsum(notDE[ord])/sum(notDE) 
	pvalQLSplineord <- sort(pvalQLSpline) 
	qvalQLSplineord <- qvalQLSpline[ord] 
#
#	DESeq p-values, q-values & FDR
#
	cds <- newCountDataSet(countsTableWithDE, conds)
	cds <- estimateSizeFactors(cds)
	cds <- estimateDispersions(cds)
	res <- nbinomTest(cds, "A", "B")
	pvalDESeq <- res$pval
	qvalDESeq <- res$padj
#
	ord <- order(pvalDESeq)
	FDR_DESeq <- cumsum(notDE[ord])/(1:nGene) 
	FPR_DESeq <- cumsum(notDE[ord])/sum(notDE) 
	pvalDESeqord <- sort(pvalDESeq) 
	qvalDESeqord <- qvalDESeq[ord] 
#
#	DESeqPF p-values, q-values & FDR
#
	resPF <- pfNbinomTest(cds, "A", "B")
	oldPvals <- resPF$pval
	ll <- levelPValues(oldPvals, plot=FALSE)
	pvalDESeqPF <- ll$pValueCorr
	qvalDESeqPF <- ll$qValueCorr
#	
	ord <- order(pvalDESeqPF)
	FDR_DESeqPF <- cumsum(notDE[ord])/(1:nGene)
	pvalDESeqPFord <- sort(pvalDESeqPF) 
	qvalDESeqPFord <- qvalDESeqPF[ord] 
#
#	DESeq2 p-values, q-values & FDR
#
	colData <- data.frame(condition = c(rep("A", nrep1), rep("B", nrep2)), 
										row.names=c(names(countsTableWithDE)))
	ddsWithDE <- DESeqDataSetFromMatrix(countData = countsTableWithDE,
                                 colData = colData,
                                 design = ~ condition)
    ddsWithDE <- DESeq(ddsWithDE)
    res <- results(ddsWithDE)
	pvalDESeq2 <- res$pval
	qvalDESeq2 <- res$padj
#
	ord <- order(pvalDESeq2)
	FDR_DESeq2 <- cumsum(notDE[ord])/(1:nGene) 
	FPR_DESeq2 <- cumsum(notDE[ord])/sum(notDE) 
	pvalDESeq2ord <- sort(pvalDESeq2) 
	qvalDESeq2ord <- qvalDESeq2[ord] 
#
#	edgeR p-values, q-values & FDR
#
	dge <- DGEList(counts=countsTableWithDE, group=group)
	dge <- calcNormFactors(dge)
	dge <- estimateCommonDisp(dge)
	dge <- estimateTagwiseDisp(dge)
	et1 <- exactTest(dge)			#  <-- The original edgeR function
	pvalEdgeR <- et1$table$PValue
#
	ord <- order(pvalEdgeR)
	FDR_edgeR <- cumsum(notDE[ord])/(1:nGene) 
	FPR_edgeR <- cumsum(notDE[ord])/sum(notDE) 
	pvalEdgeRord <- sort(pvalEdgeR) 
	qvalEdgeRord <- topTags(et1, n=nGene)$table$FDR 
#
#	edgeR polyFit p-values, q-values & FDR
#
	et2 <- pfExactTest(dge)	#  <-- Polyfit replacement edgeR function
	oldPvals <- et2$table$PValue
	ll <- levelPValues(oldPvals, plot=FALSE)
	pvalEdgeRPF <- ll$pValueCorr
	qvalEdgeRPF <- ll$qValueCorr
#
	ord <- order(pvalEdgeRPF)
	FDR_edgeRPF <- cumsum(notDE[ord])/(1:nGene)
	pvalEdgeRPFord <- sort(pvalEdgeRPF) 
	qvalEdgeRPFord <- qvalEdgeRPF[ord] 
#
#	PoissonSeq p-values, q-values & FDR
#
	dat <- list(n = countsTableWithDE,
				y = c(rep(1, nrep1), rep(2, nrep2)),
				type = "twoclass", 
				pair = FALSE)
	resPoissonSeq <- PS.Main(dat)
	set.seed(seed=NULL)  # because some idiot put a call to set.seed() in PS.main()
#
	ord <- resPoissonSeq$gname
	FDR_PoissonSeq <- cumsum(notDE[ord])/(1:nGene) 
	FPR_PoissonSeq <- cumsum(notDE[ord])/sum(notDE) 
	pvalPoissonSeqord <- resPoissonSeq$pval
	qvalPoissonSeqord <- resPoissonSeq$fdr
#
#####################################################
#
#	Plotting FDRs
#
	dev.set(plotWindowFDR)
#
	plotSpacing <- 100
	selected <- seq(1,nGene,by= plotSpacing)
#
	plot( selected, FDR_DESeq[selected],
	  xlab=paste("Number called"),
	  ylab="FDR",ylim=c(0,1), 
	  main= mainLabel,
	  type="l",lty=1,lwd=1,col="navyblue")
#
	points(selected, FDR_DESeq[selected], type="l",lty=1,lwd=1, col="navyblue" )
	points(selected, FDR_DESeq2[selected], type="l",lty=1,lwd=1, col="black" )
	points(selected, FDR_edgeR[selected], type="l",lty=1,lwd=1, col="red3" )
	points(selected, FDR_PoissonSeq[selected], type="l",lty=1,lwd=1, col="darkgreen" )
#
	points(selected, qvalDESeqord[selected], type="l", lty=2, lwd=1, col="deepskyblue" )
	points(selected, qvalDESeq2ord[selected], type="l", lty=2, lwd=1, col="grey40" )
	points(selected, qvalEdgeRord[selected], type="l", lty=2, lwd=1, col="chocolate" )
	points(selected, qvalPoissonSeqord[selected], type="l", lty=2, lwd=1, col="green" )
#
	points(selected, qvalDESeqPFord[selected], type="l", lty=4, lwd=1 ,col="blue")
	points(selected, qvalEdgeRPFord[selected], type="l", lty=4, lwd=1, col="red" )
#
	points(selected, FDR_QLSpline[selected], type="l",lty=1,lwd=1, col="purple" )
	points(selected, qvalQLSplineord[selected], type="l", lty=2, lwd=1, col="violet" )
#
	text <- c("DESeq2", "DESeq2_True", "DESeq","DESeq_PF", "DESeq_True", "edgeR",
		   "edgeR_PF","edgeR_True",
		   "PoissonSeq", "PoissonSeq_True", "QLSpline", "QLSpline_True")
	col <- c("grey40", "black", "deepskyblue","blue","navyblue","chocolate","red","red3",
								"green","darkgreen", "violet", "purple")
	lty <- c(2,1,2,4,1,2,4,1,2,1,2,1)
	legend("bottomright",text,text.col=col ,box.col="white",lwd = 1,lty=lty,col= col)
#
#	Plot left part, i.e. most significant genes
#
	xtop <- 1.0*pDE*nGene
	ytopFDR <- 1.1 * FDR_QLSpline[round(xtop)]
#
	plotSpacing <- 10
	selected <- c(1:199, seq(200, xtop,by= plotSpacing))
#
	plot( selected, FDR_DESeq[selected],
#	  xlab=paste("Number called [",rep1,", ",rep1,"]", sep=""),
	  xlab=paste("Number called"),
	  ylab="FDR", xlim=c(0, xtop), ylim=c(0, ytopFDR), 
	  main="",
	  type="l",lty=1,lwd=1,col="navyblue")
#
	points( selected, FDR_DESeq[selected], type="l",lty=1,lwd=1, col="navyblue" )
	points( selected, FDR_DESeq2[selected], type="l",lty=1,lwd=1, col="black" )
	points( selected, FDR_edgeR[selected], type="l",lty=1,lwd=1, col="red3" )
	points( selected, FDR_PoissonSeq[selected], type="l",lty=1,lwd=1, col="darkgreen" )
#
	points( selected, qvalDESeqord[selected], type="l", lty=2, lwd=1, col="deepskyblue" )
	points(selected, qvalDESeq2ord[selected], type="l", lty=2, lwd=1, col="grey40" )
	points( selected, qvalEdgeRord[selected], type="l", lty=2, lwd=1, col="chocolate" )
	points( selected, qvalPoissonSeqord[selected], type="l", lty=2, lwd=1, col="green" )
#
	points( selected, qvalDESeqPFord[selected], type="l", lty=4, lwd=1 ,col="blue")
	points( selected, qvalEdgeRPFord[selected], type="l", lty=4, lwd=1, col="red" )
#
	points( selected, FDR_QLSpline[selected], type="l",lty=1,lwd=1, col="purple" )
	points( selected, qvalQLSplineord[selected], type="l", lty=2, lwd=1, col="violet" )
#
#####################################################
#
#	Plotting FPRs
#
	dev.set(plotWindowFPR)
#
	plotSpacing <- 100
	selected <- seq(1,nGene,by= plotSpacing)
#
	plot( selected, FPR_DESeq[selected],
#	  xlab=paste("Number called [",rep1,", ",rep1,"]", sep=""),
	  xlab=paste("Number called"),
	  ylab="FPR",ylim=c(0,1), 
	  main= mainLabel,
	  type="l",lty=1,lwd=1,col="navyblue")
#
	points(selected, FPR_DESeq[selected], type="l",lty=1,lwd=1, col="navyblue" )
	points(selected, FPR_edgeR[selected], type="l",lty=1,lwd=1, col="red3" )
	points(selected, FPR_PoissonSeq[selected], type="l",lty=1,lwd=1, col="darkgreen" )
#
	points(selected, pvalDESeqord[selected], type="l", lty=2, lwd=1, col="deepskyblue" )
	points(selected, pvalEdgeRord[selected], type="l", lty=2, lwd=1, col="chocolate" )
	points(selected, pvalPoissonSeqord[selected], type="l", lty=2, lwd=1, col="green" )
#
	points(selected, pvalDESeqPFord[selected], type="l", lty=4, lwd=1 ,col="blue")
	points(selected, pvalEdgeRPFord[selected], type="l", lty=4, lwd=1, col="red" )
#
	points(selected, FPR_QLSpline[selected], type="l",lty=1,lwd=1, col="purple" )
	points(selected, pvalQLSplineord[selected], type="l", lty=2, lwd=1, col="violet" )
#
	text <- c("DESeq","DESeq_PF", "DESeq_True", "edgeR",
		   "edgeR_PF","edgeR_True",
		   "PoissonSeq", "PoissonSeq_True", "QLSpline", "QLSpline_True")
	col <- c("deepskyblue","blue","navyblue","chocolate","red","red3",
								"green","darkgreen", "violet", "purple")
	lty <- c(2,4,1,2,4,1,2,1,2,1)
	legend("bottomright",text,text.col=col ,box.col="white",lwd = 1,lty=lty,col= col)
#
#	Plot left part, i.e. most significant genes
#
	xtop <- 1.0*pDE*nGene
	ytopFPR <- 0.6 * FPR_QLSpline[round(xtop)]
#
	plotSpacing <- 10
	selected <- c(1:199, seq(200, xtop,by= plotSpacing))
#
	plot( selected, FPR_DESeq[selected],
#	  xlab=paste("Number called [",rep1,", ",rep1,"]", sep=""),
	  xlab=paste("Number called"),
	  ylab="FPR", xlim=c(0, xtop), ylim=c(0, ytopFPR), 
	  main="",
	  type="l",lty=1,lwd=1,col="navyblue")
#
	points( selected, FPR_DESeq[selected], type="l",lty=1,lwd=1, col="navyblue" )
	points( selected, FPR_edgeR[selected], type="l",lty=1,lwd=1, col="red3" )
	points( selected, FPR_PoissonSeq[selected], type="l",lty=1,lwd=1, col="darkgreen" )
#
	points( selected, pvalDESeqord[selected], type="l", lty=2, lwd=1, col="deepskyblue" )
	points( selected, pvalEdgeRord[selected], type="l", lty=2, lwd=1, col="chocolate" )
	points( selected, pvalPoissonSeqord[selected], type="l", lty=2, lwd=1, col="green" )
#
	points( selected, pvalDESeqPFord[selected], type="l", lty=4, lwd=1 ,col="blue")
	points( selected, pvalEdgeRPFord[selected], type="l", lty=4, lwd=1, col="red" )
#
	points( selected, FPR_QLSpline[selected], type="l",lty=1,lwd=1, col="purple" )
	points( selected, pvalQLSplineord[selected], type="l", lty=2, lwd=1, col="violet" )
#
#####################################################
